@echo off
setlocal

:: Define el nombre de la tarea
set "TASK_NAME=CosteCopias_EjecucionDiaria"

:: Define la ruta completa a tu ejecutable
:: Asegúrate de que esta ruta sea EXACTA donde se encuentra tu CosteCopias.exe
set "APP_PATH=C:\CosteCopias\CosteCopias\CostePorCopias.exe"

:: Genera un número aleatorio de 0 a 59
set /a RANDOM_MINUTE=%RANDOM% * 60 / 32768
:: Si el número es de un solo dígito, añade un 0 delante para que siempre sea de dos dígitos
if %RANDOM_MINUTE% LSS 10 (
    set "RANDOM_MINUTE=0%RANDOM_MINUTE%"
)

:: Define la hora de ejecución (formato HH:MM)
set "SCHEDULE_TIME=10:%RANDOM_MINUTE%"

echo.
echo =========================================================
echo  Creando/Actualizando Tarea Programada para CosteCopias
echo =========================================================
echo.
echo Nombre de la tarea: %TASK_NAME%
echo Ruta del ejecutable: %APP_PATH%
echo Hora de ejecucion: %SCHEDULE_TIME%
echo.

:: Comprueba si el archivo ejecutable existe
if not exist "%APP_PATH%" (
    echo ERROR: El archivo "%APP_PATH%" no se encontro.
    echo Asegurate de que la ruta es correcta.
    goto :end
)

:: Elimina la tarea existente si ya existe (para asegurar una actualizacion limpia)
echo Intentando eliminar tarea existente (si aplica)...
schtasks /delete /tn "%TASK_NAME%" /f > nul 2>&1
if %errorlevel% equ 0 (
    echo Tarea existente eliminada.
) else (
    echo No se encontro tarea existente o no se pudo eliminar.
)

:: Crea la nueva tarea programada
:: /TR: Ruta del programa a ejecutar
:: /SC DAILY: Frecuencia diaria
:: /ST: Hora de inicio
:: /F: Fuerza la creacion (sobrescribe si existe)
:: /RU SYSTEM: Ejecuta la tarea bajo la cuenta SYSTEM (no requiere usuario logueado, altos privilegios)
::             Esto permite que se ejecute incluso si el ordenador esta bloqueado o nadie ha iniciado sesion.
echo Creando la tarea programada...
schtasks /create /tn "%TASK_NAME%" /tr "%APP_PATH%" /sc DAILY /st %SCHEDULE_TIME% /f /ru SYSTEM

if %errorlevel% equ 0 (
    echo.
    echo =========================================================
    echo  TAREA PROGRAMADA CREADA/ACTUALIZADA CON EXITO
    echo =========================================================
    echo.
    echo La aplicacion "%APP_PATH%" se ejecutara cada dia a las %SCHEDULE_TIME%.
    echo Puedes verificar la tarea en el "Programador de Tareas" de Windows.
) else (
    echo.
    echo =========================================================
    echo  ERROR AL CREAR/ACTUALIZAR LA TAREA PROGRAMADA
    echo =========================================================
    echo.
    echo Asegurate de ejecutar este script como ADMINISTRADOR.
    echo Para ver mas detalles del error, ejecuta el comando anterior manualmente en CMD.
)

:end
echo.
pause